/* Copyright (C) 1997-2001 Agilent Technologies */
/* VXIplug&play Instrument Driver for the Agilent E1465*/

#ifndef hpe1465_INCLUDE 
#define hpe1465_INCLUDE
#include "vpptype.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*=============================*/
/*           HPE1465           */
/*=============================*/
/* Framework Revision: WIN95 4.0 */
/*                     WINNT 4.0 */
/* Driver Revision:    A.02.06 */
/* Firmware Revision:  G.09.00 */
/*=============================*/

/*=============================*/
/* Source Files:               */
/*=============================*/
/*   hpe1465.c                 */
/*   hpe1465.h                 */
/*=============================*/

/*=============================*/
/* WIN Framework Files         */
/*=============================*/
/*   hpe1465.def               */
/*   hpe1465.rc                */
/*   hpe1465.bas               */
/*=============================*/

/******  Returned error status values *****/
/* Common Error numbers start at BFFC0D00 */
#define hpe1465_INSTR_ERROR_NOT_VXI       (_VI_ERROR+0x3FFC0D00L) /* 0xBFFC0D00 */
/* D01 unused*/
#define hpe1465_INSTR_ERROR_NULL_PTR      (_VI_ERROR+0x3FFC0D02L) /* 0xBFFC0D02 */
#define hpe1465_INSTR_ERROR_RESET_FAILED  (_VI_ERROR+0x3FFC0D03L) /* 0xBFFC0D03 */
#define hpe1465_INSTR_ERROR_UNEXPECTED    (_VI_ERROR+0x3FFC0D04L) /* 0xBFFC0D04 */
#define hpe1465_INSTR_ERROR_INV_SESSION   (_VI_ERROR+0x3FFC0D05L) /* 0xBFFC0D05 */
#define hpe1465_INSTR_ERROR_LOOKUP        (_VI_ERROR+0x3FFC0D06L) /* 0xBFFC0D06 */
#define hpe1465_INSTR_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L) /* 0xBFFC0D07 */

#define hpe1465_USER_ERROR_HANDLER			-1

/******   Used by Status System Functions   *****/
#define hpe1465_STB_MAV				5 

#define hpe1465_ESR_OPC				601
#define hpe1465_ESR_QUERY_ERROR			603
#define hpe1465_ESR_DEVICE_DEPENDENT_ERROR		604
#define hpe1465_ESR_EXECUTION_ERROR			605
#define hpe1465_ESR_COMMAND_ERROR			606

#define hpe1465_OPER_SCAN_DONE			809


/******   Used by Function hpe1465_timeOut   *****/
#define  hpe1465_TIMEOUT_MAX  2147483647
#define  hpe1465_TIMEOUT_MIN  0

/* required plug and play functions from VPP-3.1*/
ViStatus _VI_FUNC hpe1465_init (ViRsrc InstrDesc, ViBoolean id_query,
                            ViBoolean do_reset, ViPSession vi );

ViStatus _VI_FUNC hpe1465_close (ViSession vi);

ViStatus _VI_FUNC hpe1465_reset (ViSession vi);

ViStatus _VI_FUNC hpe1465_self_test (ViSession vi, ViPInt16 test_result,
                                 ViChar _VI_FAR test_message[]);

ViStatus _VI_FUNC hpe1465_error_query (ViSession vi, ViPInt32 error_number,
                                   ViChar _VI_FAR error_message[]);

ViStatus _VI_FUNC hpe1465_error_message (ViSession vi, ViStatus error_number,
                                     ViChar _VI_FAR message[]);

ViStatus _VI_FUNC hpe1465_revision_query (ViSession vi, ViChar _VI_FAR driver_rev[],
                                      ViChar _VI_FAR instr_rev[]);

/* other standard functions */

ViStatus _VI_FUNC hpe1465_dcl(ViSession vi);

ViStatus _VI_FUNC hpe1465_errorQueryDetect(ViSession vi, ViBoolean errDetect);

ViStatus _VI_FUNC hpe1465_errorQueryDetect_Q(ViSession vi, ViPBoolean pErrDetect);

ViStatus _VI_FUNC hpe1465_opc(ViSession vi);

ViStatus _VI_FUNC hpe1465_opc_Q(ViSession vi, ViPInt16 opc);

ViStatus _VI_FUNC hpe1465_readStatusByte_Q(ViSession vi, ViPInt16 statusByte);

ViStatus _VI_FUNC hpe1465_statEvenClr(ViSession vi);

ViStatus _VI_FUNC hpe1465_statEven_Q(ViSession vi, ViInt32 happening,
                                 ViPBoolean pEvent);

#ifdef INSTR_CALLBACKS

typedef void (_VI_FUNCH _VI_PTR  hpe1465_InstrEventHandler)(
        ViSession vi, ViInt32 happening, ViAddr userData);     
	
ViStatus _VI_FUNC hpe1465_statEvenHdlr(ViSession vi, ViInt32 happening,       
                                   hpe1465_InstrEventHandler eventHandler,
                                   ViAddr userData);

typedef void (_VI_FUNCH _VI_PTR _VI_PTR hpe1465_InstrPEventHandler)(
	ViSession vi, ViInt32 happening, ViAddr userData);

ViStatus _VI_FUNC hpe1465_statEvenHdlr_Q(ViSession vi, ViInt32 happening,
                                     hpe1465_InstrPEventHandler pEventHandler,
                                     ViPAddr pUserData);

ViStatus _VI_FUNC hpe1465_statEvenHdlrDelAll(ViSession vi);
#endif /* INSTR_CALLBACKS */

ViStatus _VI_FUNC hpe1465_timeOut (ViSession vi, ViInt32 timeOut);

ViStatus _VI_FUNC hpe1465_timeOut_Q (ViSession vi, ViPInt32 timeOut);

ViStatus _VI_FUNC hpe1465_trg(ViSession vi);

ViStatus _VI_FUNC hpe1465_wai(ViSession vi);

/* Instr Specific Functions follow */


/******   Used by Function hpe1465_armCoun   *****/
#define  hpe1465_ARM_COUN_MAX  32767
#define  hpe1465_ARM_COUN_MIN  1


/******   Used by Function hpe1465_closRowCol16x16   *****/
#define  hpe1465_CARD_MAX  99
#define  hpe1465_CARD_MIN  1
#define  hpe1465_ROW_15  15
#define  hpe1465_ROW_0  0
#define  hpe1465_COL_15  15
#define  hpe1465_COL_0  0


/******   Used by Function hpe1465_closRowCol4x64   *****/
/*  hpe1465_CARD_MAX  */
/*  hpe1465_CARD_MIN  */
#define  hpe1465_ROW_3  3
/*  hpe1465_ROW_0  */
#define  hpe1465_COL_63  63
/*  hpe1465_COL_0  */


/******   Used by Function hpe1465_closRowCol8x32   *****/
/*  hpe1465_CARD_MAX  */
/*  hpe1465_CARD_MIN  */
#define  hpe1465_ROW_7  7
/*  hpe1465_ROW_0  */
#define  hpe1465_COL_31  31
/*  hpe1465_COL_0  */


/******   Used by Function hpe1465_outpEcltStat_M   *****/
#define  hpe1465_ECLTNUM_MAX  1
#define  hpe1465_ECLTNUM_MIN  0


/******   Used by Function hpe1465_outpEcltStat_M_Q   *****/
/*  hpe1465_ECLTNUM_MAX  */
/*  hpe1465_ECLTNUM_MIN  */


/******   Used by Function hpe1465_outpTtltStat_M   *****/
#define  hpe1465_TTLTNUM_MAX  7
#define  hpe1465_TTLTNUM_MIN  0


/******   Used by Function hpe1465_outpTtltStat_M_Q   *****/
/*  hpe1465_TTLTNUM_MAX  */
/*  hpe1465_TTLTNUM_MIN  */


/******   Used by Function hpe1465_routClos   *****/
#define  hpe1465_CHANNEL_MAX  999999
#define  hpe1465_CHANNEL_MIN  100


/******   Used by Function hpe1465_routClos_Q   *****/
/*  hpe1465_CHANNEL_MAX  */
/*  hpe1465_CHANNEL_MIN  */


/******   Used by Function hpe1465_routOpen   *****/
/*  hpe1465_CHANNEL_MAX  */
/*  hpe1465_CHANNEL_MIN  */


/******   Used by Function hpe1465_routOpen_Q   *****/
/*  hpe1465_CHANNEL_MAX  */
/*  hpe1465_CHANNEL_MIN  */


/******   Used by Function hpe1465_systCdes_Q   *****/
/*  hpe1465_CARD_MAX  */
/*  hpe1465_CARD_MIN  */


/******   Used by Function hpe1465_systCpon   *****/
/*  hpe1465_CARD_MAX  */
/*  hpe1465_CARD_MIN  */


/******   Used by Function hpe1465_systCtyp_Q   *****/
/*  hpe1465_CARD_MAX  */
/*  hpe1465_CARD_MIN  */


/******   Used by Function hpe1465_trigSour   *****/
#define  hpe1465_TRIG_SOUR_BUS  0
#define  hpe1465_TRIG_SOUR_ECLT0  1
#define  hpe1465_TRIG_SOUR_ECLT1  2
#define  hpe1465_TRIG_SOUR_HOLD  3
#define  hpe1465_TRIG_SOUR_IMM  4
#define  hpe1465_TRIG_SOUR_TTLT0  5
#define  hpe1465_TRIG_SOUR_TTLT1  6
#define  hpe1465_TRIG_SOUR_TTLT2  7
#define  hpe1465_TRIG_SOUR_TTLT3  8
#define  hpe1465_TRIG_SOUR_TTLT4  9
#define  hpe1465_TRIG_SOUR_TTLT5  10
#define  hpe1465_TRIG_SOUR_TTLT6  11
#define  hpe1465_TRIG_SOUR_TTLT7  12
#define  hpe1465_TRIG_SOUR_EXT  13


/******   Used by Function hpe1465_trigSour_Q   *****/
/*  hpe1465_TRIG_SOUR_BUS  */
/*  hpe1465_TRIG_SOUR_ECLT0  */
/*  hpe1465_TRIG_SOUR_ECLT1  */
/*  hpe1465_TRIG_SOUR_HOLD  */
/*  hpe1465_TRIG_SOUR_IMM  */
/*  hpe1465_TRIG_SOUR_TTLT0  */
/*  hpe1465_TRIG_SOUR_TTLT1  */
/*  hpe1465_TRIG_SOUR_TTLT2  */
/*  hpe1465_TRIG_SOUR_TTLT3  */
/*  hpe1465_TRIG_SOUR_TTLT4  */
/*  hpe1465_TRIG_SOUR_TTLT5  */
/*  hpe1465_TRIG_SOUR_TTLT6  */
/*  hpe1465_TRIG_SOUR_TTLT7  */
/*  hpe1465_TRIG_SOUR_EXT  */

ViStatus _VI_FUNC hpe1465_abor  (
  ViSession vi);

ViStatus _VI_FUNC hpe1465_armCoun  (
  ViSession vi,
  ViInt16 armCoun);

ViStatus _VI_FUNC hpe1465_armCoun_Q  (
  ViSession vi,
  ViPInt16 armCoun);

ViStatus _VI_FUNC hpe1465_closRowCol16x16  (
  ViSession vi,
  ViInt16 Card_Number,
  ViInt16 Row,
  ViInt16 Column);

ViStatus _VI_FUNC hpe1465_closRowCol4x64  (
  ViSession vi,
  ViInt16 Card_Number,
  ViInt16 Row,
  ViInt16 Column);

ViStatus _VI_FUNC hpe1465_closRowCol8x32  (
  ViSession vi,
  ViInt16 Card_Number,
  ViInt16 Row,
  ViInt16 Column);

ViStatus _VI_FUNC hpe1465_initCont  (
  ViSession vi,
  ViBoolean initCont);

ViStatus _VI_FUNC hpe1465_initCont_Q  (
  ViSession vi,
  ViPBoolean initCont);

ViStatus _VI_FUNC hpe1465_initImm  (
  ViSession vi);

ViStatus _VI_FUNC hpe1465_outpEcltStat_M  (
  ViSession vi,
  ViInt16 ecltNum,
  ViBoolean outpEcltStat);

ViStatus _VI_FUNC hpe1465_outpEcltStat_M_Q  (
  ViSession vi,
  ViInt16 ecltNum,
  ViPBoolean outpEcltStat);

ViStatus _VI_FUNC hpe1465_outpStat  (
  ViSession vi,
  ViBoolean outpStat);

ViStatus _VI_FUNC hpe1465_outpStat_Q  (
  ViSession vi,
  ViPBoolean outpStat);

ViStatus _VI_FUNC hpe1465_outpTtltStat_M  (
  ViSession vi,
  ViInt16 ttltNum,
  ViBoolean outpTtltStat);

ViStatus _VI_FUNC hpe1465_outpTtltStat_M_Q  (
  ViSession vi,
  ViInt16 ttltNum,
  ViPBoolean outpTtltStat);

ViStatus _VI_FUNC hpe1465_routClos  (
  ViSession vi,
  ViInt32 channel);

ViStatus _VI_FUNC hpe1465_routClosList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1465_routClosList_Q  (
  ViSession vi,
  ViString channelList,
  ViChar _VI_FAR routClosList[]);

ViStatus _VI_FUNC hpe1465_routClos_Q  (
  ViSession vi,
  ViInt32 channel,
  ViPBoolean routClos);

ViStatus _VI_FUNC hpe1465_routOpen  (
  ViSession vi,
  ViInt32 channel);

ViStatus _VI_FUNC hpe1465_routOpenList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1465_routOpenList_Q  (
  ViSession vi,
  ViString channelList,
  ViChar _VI_FAR routOpenList[]);

ViStatus _VI_FUNC hpe1465_routOpen_Q  (
  ViSession vi,
  ViInt32 channel,
  ViPBoolean routOpen);

ViStatus _VI_FUNC hpe1465_routScanList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1465_systCdes_Q  (
  ViSession vi,
  ViInt16 card,
  ViChar _VI_FAR systCdes[]);

ViStatus _VI_FUNC hpe1465_systCpon  (
  ViSession vi,
  ViInt16 card);

ViStatus _VI_FUNC hpe1465_systCtyp_Q  (
  ViSession vi,
  ViInt16 card,
  ViChar _VI_FAR systCtyp[]);

ViStatus _VI_FUNC hpe1465_trigSour  (
  ViSession vi,
  ViInt16 trigSour);

ViStatus _VI_FUNC hpe1465_trigSour_Q  (
  ViSession vi,
  ViPInt16 trigSour);




/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
}    /* end of "C" externs for C++ */
#endif 

#endif /* hpe1465_INCLUDE */

